clear;clc;
close all;

cepath='D:\MATLAB-2018\CompEcon\'; path([cepath 'cetools;' cepath 'cedemos'],path);

%addpath([pwd,'/Exogenous_files']) // pwd: returns the path to the current
%folder

%% Parameters and Exo vars
e = 0.70;
Psim = 0.5132; % sample: 0.5132, test: 0.50, census2015: 0.3944; 
Psif = 0.4883; % sample: 0.5083, test: 0.45, census2015: 0.4192; 
% (if Psim <= Psif, part value will show "solver failed")

wU_f_base = 1; 
wU_m_base = 1.36; 
wS_f_base = 1.62; 
wS_m_base = 2.06; 

mu = 0.50;

%% Sex ratio
Nfemale = (0.80:0.01:0.97)'; % ' ---> column vector; std=0.069 in sample
ratio = 1./Nfemale;
n = size(Nfemale,1);
 
%% Edu_correlation, Gini, Theta and Pi
CORR1 = zeros(n,1);
CORR_endo = zeros(n,1);
Gini_Sergei_1 = zeros(n,1);
Gini_Sergei_2 = zeros(n,1);
Gini_Sergei_3 = zeros(n,1);
Gini_1 = zeros(n,1);
Gini_2 = zeros(n,1);
Gini_3 = zeros(n,1);
Theil_T = zeros(n,1);
Theil_L = zeros(n,1);
CV = zeros(n,1);
qvalue = zeros(8,n);

beta=3;

%% Endogenizing education decision
EPsim_grid = (0:0.01:1)';
EPsim_size = length(EPsim_grid);

EPsif_grid = (0:0.01:1)';
EPsif_size = length(EPsif_grid); 

EPsi = zeros(n,2);

%% Iteration 

for i = 1:n
    wU_f = wU_f_base;
    wU_m = wU_m_base; 
    wS_f = wS_f_base; 
    wS_m = wS_m_base; 
    
    Nf = Nfemale(i)
    
    % CP(Dis,0,1)
    % need define f that returns the function value (Dis) and Jacobian at
    % arbitrary point, see MeFuncCP
    
    func = @(q) MeEquiMatch(q, Nf, Psim, Psif, e, wS_m, wS_f, wU_m, wU_f, mu); 
    % declare that unknow variable q has the function form: q = H (exo_variables)
    
    x0 = ones(8,1)/2; % initial guess of x
    
    [~, ~] = MeFuncCP(x0, func); 
    % input guess value, function form; return the fvalue and jacobian of 'func',
    % What does this mean Warning: Failure to converge in ncpsolve 
    
    myfun = @(q) MeFuncCP(q, func); 
    % once have the favlue and fjac, declare q you wanna solve, input q and
    % function form of q
    
    qlow  = zeros(8,1); % lower bound
    qhigh = ones(8,1); % upper bound
    
    qq = ncpsolve(myfun, qlow, qhigh, x0);
    % applying Newton's method, use semismooth formulation [phi^{+-}(u,v)=u+v+-\sqrt{u^2+v^2}]
    % to solve CP use minmax change default option 
    % optset('ncpsolve','type','minmax')
    
    %  qvalue(i) = qq;
    
    % Dis = MeEquiMatch(qq);  solved q, compute Dis value
    Dis = func(qq)';
    
    if max(abs(Dis))>1e-4
        disp('solver failed')
        pause
    end
    
    CORR1(i) = MeEduCorr(qq, Nf, Psim, Psif);
    
    [thetaSm(i), thetaUm(i), thetaSf(i), thetaUf(i)] = Metheta(qq, Nf, Psim, Psif);
    [piss(i), pisu(i), pius(i), piuu(i), pis(i), piu(i)] = Mepi(qq, Nf, Psim, Psif);
    % thetaSm(1*18), piss(1*18)
    Theta = [thetaSm; thetaUm; thetaSf; thetaUf]';
    % Theta(4*18)'
  
    Pi = [piss; pisu; pius; piuu; pis; piu]'; 
    % (6*18)->Pi_{18*6}
    qSS_m(i) = qq(1);
    qSS_f(i) = qq(2);
    qSU_m(i) = qq(3);
    qUS_f(i) = qq(4);
    qUS_m(i) = qq(5);
    qUU_m(i) = qq(6);
    qSU_f(i) = qq(7);
    qUU_f(i) = qq(8);

    qvalue = [qSS_m; qSS_f; qSU_m; qUS_f; qUS_m; qUU_m; qSU_f; qUU_f]';
    
    %% Gini of Sergei, Including Singles
 
    income_1 = repmat([wS_m+wS_f; wS_m+wU_f; wU_m+wS_f; wU_m+wU_f; wS_m; wU_m],1,n);
    fraction_1 = [piss(i); pisu(i); pius(i); piuu(i); pis(i); piu(i)]; 
    
    Gini_Sergei_1(i) = MeGini_test_Serhiy(income_1,fraction_1);

    %% Gini of Sergei, Excluding Singles
    income_2 = repmat([wS_m+wS_f; wS_m+wU_f; wU_m+wS_f; wU_m+wU_f],1,n);
    frac_2_SS(i) = piss/(piss+pisu+pius+piuu);
    frac_2_SU(i) = pisu/(piss+pisu+pius+piuu);
    frac_2_US(i) = pius/(piss+pisu+pius+piuu);
    frac_2_UU(i) = piuu/(piss+pisu+pius+piuu);
    fraction_2 = [frac_2_SS(i); frac_2_SU(i); frac_2_US(i); frac_2_UU(i)]; 
    
    Gini_Sergei_2(i) = MeGini_test_Serhiy(income_2,fraction_2);
     
    %% Gini of Sergei, per capita income inequality
    income_3 = repmat([((wS_m+wS_f)/2);((wS_m+wS_f)/2);((wS_m+wU_f)/2);((wS_m+wU_f)/2);((wU_m+wS_f)/2);...
        ((wU_m+wS_f)/2);((wU_m+wU_f)/2);((wU_m+wU_f)/2);wS_m; wU_m],1,n);

    frac_3_SS(i) = piss/(2*piss+2*pisu+2*pius+2*piuu+pis+piu);
    frac_3_SU(i) = pisu/(2*piss+2*pisu+2*pius+2*piuu+pis+piu);
    frac_3_US(i) = pius/(2*piss+2*pisu+2*pius+2*piuu+pis+piu);
    frac_3_UU(i) = piuu/(2*piss+2*pisu+2*pius+2*piuu+pis+piu);
    frac_3_S(i)  = pis/(2*piss+2*pisu+2*pius+2*piuu+pis+piu);
    frac_3_U(i)  = piu/(2*piss+2*pisu+2*pius+2*piuu+pis+piu);

    fraction_3 = [frac_3_SS(i); frac_3_SS(i); frac_3_SU(i); frac_3_SU(i); frac_3_US(i); ...
        frac_3_US(i); frac_3_UU(i); frac_3_UU(i); frac_3_S(i); frac_3_U(i)]; 

    Gini_Sergei_3(i) = MeGini_test_Serhiy(income_3,fraction_3);

    %% Gini of my own
    
    [Gini_1(i), Gini_2(i), Gini_3(3)] = MeGini_test_myself(qq, Nf, Psim, Psif, wS_m, wS_f, wU_m, wU_f);
  
    %% Inequality measures

    [CV(i), CV_2(i), Theil_T(i), Theil_T_2(i), Theil_L(i), Theil_L_2(i), VarianceLog1(i), VarianceLog2(i), AssortHHIncPremium(i), AssortHHIncPremium2(i), E_beta(i), E_beta2(i)] = ...
    MeIneqMeasures(beta, qq, Nf, Psim, Psif, wS_m, wS_f, wU_m, wU_f);

    %% Solve endogenous education decision
    
    func = @(EPsi) MeEVagent(EPsi, Nf, e, wU_f, wU_m, wS_f, wS_m, qq); %
    
    y0 = ones(2,1)/2; % initial guess of y
    
    [fval, fjac] = MeFuncCP_Edu(y0, func); % What does this mean Warning: Failure to converge in ncpsolve 
    
    myfun = @(EPsi) MeFuncCP_Edu(EPsi, func); % 
    
    EPsilow  = zeros(2,1); % lower bound
    EPsihigh = ones(2,1); % upper bound
    
    EPsi_value = ncpsolve(myfun, EPsilow, EPsihigh, y0)
 
    Dis = func(EPsi_value)';
    
    if max(abs(Dis))>1e-6
        disp('solver failed')
        pause
    end
    
    EPsim(i) = EPsi_value(1);
    EPsif(i) = EPsi_value(2);
    
end


%% Function Iteration to solve Education investment
%{
tic

tolerance = 1e-6;

while (Dis_Edu > tolerance)

    for i = 1:EPsim_size

        for j = 1:EPsif_size
            
        EPsim = EPsim_grid(i);
        EPsif = EPsif_grid(j);

        Dis_Edu = MeEVagent(EPsi, Nf, e, wU_f, wU_m, wS_f, wS_m, qq)

        end

    end

    if 
                disp('solver failure')
                pause
    end

end

toc
%}

% fprintf(1,'After %d periods, unconditional probability is: \n', i);

%}
% save file
% load file

